/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.BaseDependencies;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConcurrentConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigUnavailableException;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;

public abstract class TypeLevelConfigApi {
    private static final Logger log = LogManager.getLogger(TypeLevelConfigApi.class);

    public static abstract class PatchAction
    extends Action<Request, StandardResponse> {
        protected PatchAction(String name) {
            super(name, Request::new, StandardResponse::new);
        }

        public static class Handler<T>
        extends Action.Handler<Request, StandardResponse> {
            private final ConfigurationRepository configRepository;
            private final CType<T> configType;

            @Inject
            public Handler(Action<Request, StandardResponse> action, CType<T> configType, Action.HandlerDependencies handlerDependencies, ConfigurationRepository configRepository) {
                super(action, handlerDependencies);
                this.configRepository = configRepository;
                this.configType = configType;
            }

            protected CompletableFuture<StandardResponse> doExecute(Request request) {
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return this.configRepository.applyPatch(this.configType, request.getPatch(), request.getIfMatch());
                    }
                    catch (ConfigValidationException e) {
                        return new StandardResponse(400).error(null, e.getMessage(), (Object)e.getValidationErrors());
                    }
                    catch (ConcurrentConfigUpdateException e) {
                        return new StandardResponse(412).error(e.getMessage());
                    }
                    catch (ConfigUpdateException e) {
                        log.error("Error while updating configuration", (Throwable)e);
                        return new StandardResponse(500).error(null, e.getMessage(), e.getDetailsAsMap());
                    }
                    catch (Exception e) {
                        log.error("Error while updating configuration", (Throwable)e);
                        return new StandardResponse(500).error(e.getMessage());
                    }
                }, this.getExecutor());
            }
        }

        public static class Request
        extends Action.Request {
            private final DocPatch patch;

            public Request(DocPatch patch) {
                this.patch = patch;
            }

            public Request(Action.UnparsedMessage message) throws ConfigValidationException {
                super(message);
                ValidationErrors validationErrors = new ValidationErrors();
                ValidatingDocNode vNode = new ValidatingDocNode(message.requiredDocNode(), validationErrors);
                this.patch = (DocPatch)vNode.get("patch").required().by(DocPatch::parseTyped);
            }

            public Object toBasicObject() {
                return ImmutableMap.of((Object)"patch", (Object)this.patch);
            }

            public DocPatch getPatch() {
                return this.patch;
            }
        }
    }

    public static abstract class PutAction
    extends Action<Request, StandardResponse> {
        protected PutAction(String name) {
            super(name, Request::new, StandardResponse::new);
        }

        public static class Handler<T>
        extends Action.Handler<Request, StandardResponse> {
            private final ConfigurationRepository configurationRepository;
            private final CType<T> configType;

            @Inject
            public Handler(Action<Request, StandardResponse> action, CType<T> configType, Action.HandlerDependencies handlerDependencies, ConfigurationRepository configurationRepository) {
                super(action, handlerDependencies);
                this.configurationRepository = configurationRepository;
                this.configType = configType;
            }

            protected final CompletableFuture<StandardResponse> doExecute(Request request) {
                return this.supplyAsync(() -> {
                    ImmutableMap configMap = this.configType.getArity() == CType.Arity.SINGLE ? ImmutableMap.of((Object)"default", request.getConfig()) : request.getConfig();
                    SgDynamicConfiguration config = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap(configMap, this.configType, this.configurationRepository.getParserContext().withExternalResources()).get();
                    try {
                        this.configurationRepository.update(this.configType, config, request.getIfMatch());
                        StandardResponse standardResponse = new StandardResponse(200).message("Configuration has been updated");
                        if (config != null) {
                            config.close();
                        }
                        return standardResponse;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (config != null) {
                                try {
                                    config.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (ConfigValidationException e) {
                            return new StandardResponse(400).error(e);
                        }
                        catch (ConcurrentConfigUpdateException e) {
                            return new StandardResponse(412).error(e.getMessage());
                        }
                        catch (ConfigUpdateException e) {
                            log.error("Error while updating configuration", (Throwable)e);
                            return new StandardResponse(500).error(null, e.getMessage(), e.getDetailsAsMap());
                        }
                    }
                });
            }
        }

        public static class Request
        extends Action.Request {
            private final Map<String, Object> config;

            public Request(Map<String, Object> config) {
                this.config = config;
            }

            public Request(Action.UnparsedMessage message) throws ConfigValidationException {
                DocNode docNode = message.requiredDocNode();
                this.config = docNode.getAsNode("config").toMap();
            }

            public Map<String, Object> getConfig() {
                return this.config;
            }

            public Object toBasicObject() {
                return ImmutableMap.of((Object)"config", this.config);
            }
        }
    }

    public static abstract class GetAction
    extends Action<StandardRequests.EmptyRequest, Response> {
        protected GetAction(String name) {
            super(name, StandardRequests.EmptyRequest::new, Response::new);
        }

        public static abstract class Handler<T>
        extends Action.Handler<StandardRequests.EmptyRequest, Response> {
            private final ConfigurationRepository configurationRepository;
            private final AuditLog auditLog;
            private final CType<T> configType;

            @Inject
            public Handler(Action<StandardRequests.EmptyRequest, Response> action, CType<T> configType, Action.HandlerDependencies handlerDependencies, ConfigurationRepository configurationRepository, BaseDependencies baseDependencies) {
                super(action, handlerDependencies);
                this.configType = configType;
                this.configurationRepository = configurationRepository;
                this.auditLog = baseDependencies.getAuditLog();
            }

            protected CompletableFuture<Response> doExecute(StandardRequests.EmptyRequest request) {
                return this.supplyAsync(this::lambda$doExecute$0);
            }

            private void logComplianceEvent(SgDynamicConfiguration<?> config) {
                LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
                fields.put(config.getCType().toLCString(), Strings.toString(config));
                this.auditLog.logDocumentRead(this.configurationRepository.getEffectiveSearchGuardIndex(), this.configType.getName(), null, fields);
            }

            /*
             * Unable to fully structure code
             */
            private /* synthetic */ Response lambda$doExecute$0() {
                try {
                    config = this.configurationRepository.getConfigurationFromIndex(this.configType, "GET API Request");
                    this.logComplianceEvent(config);
                    result = new LinkedHashMap<String, Object>();
                    if (this.configType.getArity() == CType.Arity.SINGLE) {
                        try {
                            parsedConfig = DocNode.parse((Format)Format.JSON).from(config.getUninterpolatedJson());
                            if (!parsedConfig.hasNonNull("default")) ** GOTO lbl16
                            result.put("content", parsedConfig.get("default"));
                        }
                        catch (DocumentParseException e) {
                            throw new ConfigUnavailableException(e);
                        }
                    } else {
                        result.put("content", UnparsedDocument.fromJson((String)config.getUninterpolatedJson()));
                    }
lbl16:
                    // 3 sources

                    result.put("_version", config.getDocVersion());
                    result.put("_seq_no", config.getSeqNo());
                    result.put("_primary_term", config.getPrimaryTerm());
                    return new Response(result);
                }
                catch (ConfigUnavailableException e) {
                    throw new CompletionException(e);
                }
            }
        }

        public static class Response
        extends Action.Response {
            private Map<String, Object> config;

            public Response() {
            }

            public Response(Map<String, Object> config) {
                this.config = config;
            }

            public Response(Action.UnparsedMessage message) throws ConfigValidationException {
                this.config = message.requiredDocNode().toMap();
            }

            public Object toBasicObject() {
                return this.config;
            }
        }
    }
}

